<?php
require __DIR__ . '/../db/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/../../api/css/style.css">
    <title>RBXMOON - TopUp</title>
</head>

<head>
  <title>RBXMOON - TopUp</title>
  <meta property="og:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta property="og:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
  <meta property="og:url" content="https://infernal.top" />
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary" />
  <meta name="twitter:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta name="twitter:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
</head>
<body>
    <div class="header">
        <div class="logo-section">
            <img src="/../api/images/logo.webp" alt="RBXMOON Logo" class="logo">
            <span class="company-name">RBXMOON</span>
           <div class="nav-links">
                <a href="/pages/tos.html" class="nav-link">TOS</a>
                <a href="https://discord.com/invites/" class="nav-link">Sell Robux</a>
                <a href="https://discord.com/invites/" class="nav-link">Discord</a>
            </div>
        </div>
        <div class="auth-section">
            <?php

            if (!isset($_SESSION['user'])) {
                echo '<a href="'.DISCORD_OAUTH_URL.'" class="login-btn" id="headerBtn">
                    <svg class="discord-icon" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152..."></path>
                    </svg>
                    Login/Register
                </a>';
            } else {
                $stmt = $pdo->prepare("SELECT balance FROM users WHERE discord_id = ?");
                $stmt->execute([$_SESSION['user']['discord_id']]);
                $balance = $stmt->fetchColumn();
                $balanceFormatted = number_format($balance, 2);

                echo '
    <div class="user-dropdown">
        <button class="user-dropdown-btn" title="View account menu">
            <img src="' . ($_SESSION['user']['thumbnail'] ?? '/../api/images/discord.png') . '" alt="avatar" class="user-avatar">
            <div class="user-details">
                <span class="user-username">'.$_SESSION['user']['username'].'</span>
                <span class="user-balance">$'.$balanceFormatted.'</span>
            </div>
            <svg class="dropdown-arrow" width="12" height="12" viewBox="0 0 12 12" fill="currentColor">
                <path d="M2 4L6 8L10 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/>
            </svg>
        </button>
        
        <div class="user-dropdown-menu">
            <a href="/pages/home.php" class="dropdown-item" title="Go to home page">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
                Home
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/pages/history.php" class="dropdown-item" title="View your transaction history and past orders">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 3v5h5"/>
                    <path d="M3.05 13A9 9 0 1 0 6 5.3L3 8"/>
                    <path d="M12 7v5l4 2"/>
                </svg>
                History
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/../api/helper2/api_logout.php" class="dropdown-item logout" title="Sign out of your account">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
        <polyline points="16 17 21 12 16 7"/>
        <line x1="21" y1="12" x2="9" y2="12"/>
    </svg>
    Logout
</a>

        </div>
    </div>';
            }
            ?>
        </div>
    </div>

    <div class="dashboard-container">
        <div class="main-content">
            <div class="withdraw-section" id="depositFormSection">
                <h2 class="section-title">Deposit</h2>
                
                <form id="withdrawForm">
                    <div class="form-group">
                        <label class="form-label">Select Cryptocurrency</label>
                        
                        <div class="custom-select-wrapper">
                            <div class="custom-select-trigger" id="selectTrigger">
                                <div class="selected-crypto">
                                    <div class="crypto-icon btc">₿</div>
                                    <span class="crypto-name">Bitcoin</span>
                                </div>
                                <svg class="dropdown-arrow" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M6 9l6 6 6-6"/>
                                </svg>
                            </div>
                            
                            <div class="custom-options" id="customOptions">
                                <div class="custom-option selected" data-value="btc">
                                    <div class="crypto-icon btc">₿</div>
                                    <span class="crypto-name">Bitcoin</span>
                                    <span class="crypto-symbol">BTC</span>
                                </div>
                                <div class="custom-option" data-value="eth">
                                    <div class="crypto-icon eth">Ξ</div>
                                    <span class="crypto-name">Ethereum</span>
                                    <span class="crypto-symbol">ETH</span>
                                </div>
                                <div class="custom-option" data-value="ltc">
                                    <div class="crypto-icon ltc">Ł</div>
                                    <span class="crypto-name">Litecoin</span>
                                    <span class="crypto-symbol">LTC</span>
                                </div>
                                <div class="custom-option" data-value="usdt">
                                    <div class="crypto-icon usdt">₮</div>
                                    <span class="crypto-name">Tether</span>
                                    <span class="crypto-symbol">USDT</span>
                                </div>
                                <div class="custom-option" data-value="usdc">
                                    <div class="crypto-icon usdc">$</div>
                                    <span class="crypto-name">USD Coin</span>
                                    <span class="crypto-symbol">USDC</span>
                                </div>
                            </div>
                            
                            <select name="coins" id="coinsSelect" class="native-select">
                                <option value="btc" selected>Bitcoin (BTC)</option>
                                <option value="eth">Ethereum (ETH)</option>
                                <option value="ltc">Litecoin (LTC)</option>
                                <option value="usdt">Tether (USDT)</option>
                                <option value="usdc">USD Coin (USDC)</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Amount in USD</label>
                        <input type="number" class="form-input" placeholder="0.00" id="amountInput" min="1" step="0.01">
                    </div>
                    
                    <button type="submit" class="submit-btn" id="submitBtn">Submit Deposit</button>
                </form>
                
                <div id="withdrawalMessage" style="margin-top: 15px; padding: 10px; border-radius: 5px; display: none;"></div>
            </div>
        </div>
    </div>

<script src="/../../api/js/deposit.js"></script>
</body>
</html>