<?php
require __DIR__ . '/../db/config.php';

// Get payment details from URL parameters
$paymentId = $_GET['payment_id'] ?? null;
$amount = $_GET['amount'] ?? null;
$currency = strtoupper($_GET['currency'] ?? '');
$address = $_GET['address'] ?? null;
$network = $_GET['network'] ?? $currency;
$token = $_GET['token'] ?? null;

// Validate required parameters
if (!$paymentId || !$amount || !$currency || !$address) {
    header('Location: https://yourmainsite.com');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/../../api/css/style.css">
    <title>RBXMOON - Payment</title>

    <meta property="og:title" content="RBXMOON - Your #1 Robux Vendor" />
    <meta property="og:description" content="Buy Robux at the best prices with the safest delivery on RBXMOON." />
    <meta property="og:type" content="website" />
</head>
<body>

    <!-- HEADER -->
    <div class="header">
        <div class="logo-section">
            <img src="/../api/images/logo.webp" alt="RBXMOON Logo" class="logo">
            <span class="company-name">RBXMOON</span>
            <div class="nav-links">
                <a href="/pages/tos.html" class="nav-link">TOS</a>
                <a href="https://discord.com/invite/" class="nav-link">Sell Robux</a>
                <a href="https://discord.com/invite/" class="nav-link">Discord</a>
            </div>
        </div>
        <div class="auth-section">
            <?php

            if (!isset($_SESSION['user'])) {
                echo '<a href="'.DISCORD_OAUTH_URL.'" class="login-btn" id="headerBtn">
                    <svg class="discord-icon" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152..."></path>
                    </svg>
                    Login/Register
                </a>';
            } else {
                $stmt = $pdo->prepare("SELECT balance FROM users WHERE discord_id = ?");
                $stmt->execute([$_SESSION['user']['discord_id']]);
                $balance = $stmt->fetchColumn();
                $balanceFormatted = number_format($balance, 2);

                echo '
    <div class="user-dropdown">
        <button class="user-dropdown-btn" title="View account menu">
            <img src="' . ($_SESSION['user']['thumbnail'] ?? '/../api/images/discord.png') . '" alt="avatar" class="user-avatar">
            <div class="user-details">
                <span class="user-username">'.$_SESSION['user']['username'].'</span>
                <span class="user-balance">$'.$balanceFormatted.'</span>
            </div>
            <svg class="dropdown-arrow" width="12" height="12" viewBox="0 0 12 12" fill="currentColor">
                <path d="M2 4L6 8L10 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/>
            </svg>
        </button>
        
        <div class="user-dropdown-menu">
            <a href="/pages/home.php" class="dropdown-item" title="Go to home page">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
                Home
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/pages/history.php" class="dropdown-item" title="View your transaction history and past orders">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 3v5h5"/>
                    <path d="M3.05 13A9 9 0 1 0 6 5.3L3 8"/>
                    <path d="M12 7v5l4 2"/>
                </svg>
                History
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/../api/helper2/api_logout.php" class="dropdown-item logout" title="Sign out of your account">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
        <polyline points="16 17 21 12 16 7"/>
        <line x1="21" y1="12" x2="9" y2="12"/>
    </svg>
    Logout
</a>

        </div>
    </div>';
            }
            ?>
        </div>
    </div>

    <!-- PAYMENT SUCCESS SECTION -->
    <div class="dashboard-container">
        <div class="main-content">
            <div class="payment-container" style="display: block;">
                <h2 class="section-title">Deposit Details</h2>

                <div class="payment-card">
                    <div class="qr-section">
                        <div class="qr-code">
                            <img id="qrCodeImage" 
                                 src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo strtolower($currency); ?>:<?php echo urlencode($address); ?>?amount=<?php echo urlencode($amount); ?>" 
                                 alt="Payment QR Code">
                        </div>
                    </div>

                    <div class="payment-details">
                        <div class="amount-display">
                            <div class="crypto-amount">
                                <span class="crypto-amount-text">
                                    <?php echo htmlspecialchars($amount); ?> <?php echo htmlspecialchars($currency); ?>
                                </span>
                                <button class="copy-btn" onclick="copyText('<?php echo htmlspecialchars($amount); ?> <?php echo htmlspecialchars($currency); ?>', this)">Copy</button>
                            </div>
                        </div>

                        <div class="network-info">
                            <span class="network-label">Network ·</span>
                            <span class="network-value"><?php echo htmlspecialchars($network); ?></span>
                        </div>

                        <div class="wallet-section">
                            <div class="wallet-label">Recipient Wallet Address</div>
                            <div class="wallet-address-box">
                                <span class="wallet-address"><?php echo htmlspecialchars($address); ?></span>
                                <button class="copy-btn" onclick="copyText('<?php echo htmlspecialchars($address); ?>', this)">Copy</button>
                            </div>
                        </div>

                        <div class="status-message">
                            ⚠️ Send only <?php echo htmlspecialchars($currency); ?> on the <?php echo htmlspecialchars($network); ?> network. 
                            Wrong network or currency will result in loss of funds.<br>
                            When your payment is confirmed, your balance will update automatically.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    function copyText(text, button) {
        navigator.clipboard.writeText(text).then(() => {
            const original = button.textContent;
            button.textContent = "✓ Copied!";
            button.style.background = "#28a745";
            setTimeout(() => {
                button.textContent = original;
                button.style.background = "";
            }, 1500);
        });
    }
    
    document.addEventListener("DOMContentLoaded", () => {
    const dropdown = document.querySelector(".user-dropdown");
    const dropdownBtn = document.querySelector(".user-dropdown-btn");

    if (dropdown && dropdownBtn) {
        // Toggle dropdown visibility
        dropdownBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("active");
        });

        // Close dropdown when clicking outside
        document.addEventListener("click", (e) => {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove("active");
            }
        });
    }
});
    </script>
</body>
</html>
