<?php
require __DIR__ . '/../db/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/../../api/css/style.css">
    <title>RBXMOON - Purchase Robux</title>
</head>

<head>
  <!-- Title that appears in the embed -->
  <title>RBXMOON - Your #1 Robux Vendor</title>

  <!-- Open Graph / Discord & WhatsApp preview -->
  <meta property="og:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta property="og:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
  <meta property="og:url" content="https://infernal.top" />
  <meta property="og:type" content="website" />

  <!-- Optional Twitter card -->
  <meta name="twitter:card" content="summary" />
  <meta name="twitter:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta name="twitter:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
</head>


<body>
<div id="customAlert" class="custom-alert">
    <svg class="alert-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
        <polyline points="22 4 12 14.01 9 11.01"></polyline>
    </svg>
    <div class="alert-content">
        <div class="alert-title">Success</div>
        <div class="alert-message">Operation completed successfully!</div>
    </div>
    <button class="alert-close" onclick="closeAlert()">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <line x1="18" y1="6" x2="6" y2="18"></line>
            <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
    </button>
</div>
    <div class="header">
        <div class="logo-section">
            <img src="/../api/images/logo.webp" alt="RBXMOON Logo" class="logo">
            <span class="company-name">RBXMOON</span>
           <div class="nav-links">
                <a href="/pages/tos.html" class="nav-link">TOS</a>
                <a href="https://discord.com/invites/" class="nav-link">Sell Robux</a>
                <a href="https://discord.com/invites/" class="nav-link">Discord</a>
            </div>
        </div>
        <div class="auth-section">
<?php


if (!isset($_SESSION['user'])) {
    echo '<a href="'.DISCORD_OAUTH_URL.'" class="login-btn" id="headerBtn">
        <svg class="discord-icon" viewBox="0 0 24 24" fill="currentColor">
            <path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4447.8648-.6083 1.2495-1.8447-.2762-3.68-.2762-5.4868 0-.1636-.3933-.4058-.8742-.6177-1.2495a.077.077 0 00-.0785-.037 19.7363 19.7363 0 00-4.8852 1.515.0699.0699 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0824.0824 0 00.0312.0561c2.0528 1.5076 4.0413 2.4228 5.9929 3.0294a.0777.0777 0 00.0842-.0276c.4616-.6304.8731-1.2952 1.226-1.9942a.076.076 0 00-.0416-.1057c-.6528-.2476-1.2743-.5495-1.8722-.8923a.077.077 0 01-.0076-.1277c.1258-.0943.2517-.1923.3718-.2914a.0743.0743 0 01.0776-.0105c3.9278 1.7933 8.18 1.7933 12.0614 0a.0739.0739 0 01.0785.0095c.1202.099.246.1981.3728.2924a.077.077 0 01-.0066.1276 12.2986 12.2986 0 01-1.873.8914.0766.0766 0 00-.0407.1067c.3604.698.7719 1.3628 1.225 1.9932a.076.076 0 00.0842.0286c1.961-.6067 3.9495-1.5219 6.0023-3.0294a.077.077 0 00.0313-.0552c.5004-5.177-.8382-9.6739-3.5485-13.6604a.061.061 0 00-.0312-.0286zM8.02 15.3312c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9555-2.4189 2.157-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419-.0019 1.3332-.9555 2.4189-2.1569 2.4189zm7.9748 0c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9554-2.4189 2.1569-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.9555 2.4189-2.1568 2.4189Z"></path>
        </svg>
        Login/Register
    </a>';
} else {
    $stmt = $pdo->prepare("SELECT balance FROM users WHERE discord_id = ?");
    $stmt->execute([$_SESSION['user']['discord_id']]);
    $balance = $stmt->fetchColumn();
    $balanceFormatted = number_format($balance, 2);

    echo '
    <div class="user-dropdown">
        <button class="user-dropdown-btn" title="View account menu">
            <img src="' . ($_SESSION['user']['thumbnail'] ?? '/../api/images/discord.png') . '" alt="avatar" class="user-avatar">
            <div class="user-details">
                <span class="user-username">'.$_SESSION['user']['username'].'</span>
                <span class="user-balance">$'.$balanceFormatted.'</span>
            </div>
            <svg class="dropdown-arrow" width="12" height="12" viewBox="0 0 12 12" fill="currentColor">
                <path d="M2 4L6 8L10 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/>
            </svg>
        </button>
        
        <div class="user-dropdown-menu">
            <a href="/pages/topup.php" class="dropdown-item" title="Add money to your account balance">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="12" y1="8" x2="12" y2="16"/>
                    <line x1="8" y1="12" x2="16" y2="12"/>
                </svg>
                Top Up
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/pages/history.php" class="dropdown-item" title="View your transaction history (Deposit and Orders)">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 3v5h5"/>
                    <path d="M3.05 13A9 9 0 1 0 6 5.3L3 8"/>
                    <path d="M12 7v5l4 2"/>
                </svg>
                History
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/../api/helper2/api_logout.php" class="dropdown-item logout" title="Sign out of your account">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
        <polyline points="16 17 21 12 16 7"/>
        <line x1="21" y1="12" x2="9" y2="12"/>
    </svg>
    Logout
</a>

        </div>
    </div>';
}
?>
        </div>

        <a id="goBackLink" class="go-back-link" style="display: none;">
            <svg viewBox="0 0 24 24" fill="currentColor">
                <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"/>
            </svg>
            Go back
        </a>
    </div>

    <div class="container">
        <div id="initialPage" class="page-content">
            <div class="purchase-header">
                <h1 class="purchase-title">Your #1 Robux Vendor!</h1>
            </div>

            <div class="purchase-modal">
                <div class="payment-section">
                    <div class="section-label">You pay</div>
                    <div class="amount-row">
                        <input type="number" class="amount-value" id="payAmount" value="8.50" min="0.10" max="212.50" step="0.01">
                        <div class="currency-symbol">$</div>
                    </div>
                    <div class="amount-buttons">
                        <button class="amount-btn" data-amount="8.50">$8.50</button>
                        <button class="amount-btn" data-amount="85">$85</button>
                        <button class="amount-btn" data-amount="212.50">$212.50</button>
                        <button class="amount-max-bal" data-amount="MAX-BAL" title="Max robux you'll get with your balance">MAX</button>
                    </div>
                </div>

                 <div class="section-label">You get</div>

                <div class="receive-row">
                    <input type="number" class="amount-value" id="receiveAmount" value="1000" min="1" max="40000" step="1">
                    <img src="https://static.wikia.nocookie.net/c3d6b9e0-23a5-44cd-887f-fb83b3a93ede/scale-to-width/755" alt="Robux" class="robux-icon">
                </div>
            </div>

            <button class="purchase-button" onclick="handlePurchaseClick()">Purchase</button>
            <center>
            <div class="section-label" style="margin-top: 10px;">
                By purchasing from us you acknowledge and accept our <a href="/pages/tos.html" style="color: #5865f2;">TOS</a>.
            </div></center>
        </div>

        <div id="step1Page" class="page-content" style="display: none;">
            <div class="purchase-header">
                <h1 class="purchase-title">Follow the tutorial closely!</h1>
            </div>

            <div class="purchase-modal">
                <h1 style="margin-bottom: 10px;">Step: 1</h1>
                <div class="payment-section">
                    <div class="section-label">
                        Create a Gamepass For: 
                        <span id="gamepass-amount">163 R$</span>
                        <button class="copy-btn" onclick="copyGamepassAmount(event)" title="Copy to clipboard">
                        Click to Copy </button>
                        <br>(DON'T FORGET TO DISABLE REGIONAL PRICING!!)
                        <br><br>
                        <strong>Note:</strong> You will receive <span id="customer-rbx-amount">125 R$</span> after purchase
                    </div>
                </div>

                <div class="section-label">Need Help creating a gamepass? Watch this video: <a href="https://youtube.com/watch?v=example" target="_blank">Tutorial Link</a></div>
            </div>

            <button class="purchase-button" onclick="goToStep2()">Next Step</button>
        </div>

        <div id="step2Page" class="page-content" style="display: none;">
            <div class="purchase-header">
                <h1 class="purchase-title">Follow the tutorial closely!</h1>
            </div>

            <div class="purchase-modal">
                <h1 style="margin-bottom: 10px;">Step: 2</h1>
                <div class="payment-section">
                    <div class="section-label">Enter Your Gamepass Id</div>
                    <div class="amount-row">
                        <input type="text" class="amount-value" id="gamepassId" placeholder="1312407845" style="font-size: 32px;">
                    </div>
                </div>

                <button class="purchase-button" onclick="checkGamepass()" style="background: red; border: none;">
                    Check
                </button>
            </div>

            <button class="purchase-button" onclick="completePurchase()">Purchase</button>
        </div>

        <div id="errorPage" class="page-content" style="display: none;">
            <div class="purchase-header">
                <h1 class="purchase-title">Order Canceled :(</h1>
            </div>

            <div class="purchase-modal">
                <h1 style="margin-bottom: 10px;">No order Id</h1>
                <div class="payment-section">
                    <div class="section-label">
                        <span>While processing your order we encountered an issue please seek immediate support by clicking on the support button and providing your order id.</span>
                    </div>
                </div>
                <img src="/../api/images/error.png" alt="error icon" style="margin-top: 20px; margin-bottom: 26px; margin-left: 25%; width: 200px;">
            </div>

            <button class="purchase-button" onclick="getSupport()">Get Support</button>
        </div>

        <div id="successPage" class="page-content" style="display: none;">
            <div class="purchase-header">
                <h1 class="purchase-title">Thanks for using RBXMOON!</h1>
            </div>

            <div class="purchase-modal">
                <h1 style="margin-bottom: 10px;" id="successOrderId" >Order Id: Null</h1>
                <div class="payment-section">
                    <div class="section-label">
                        <span>Your order is listed successfully you will receive it within 48hours. <strong> WARNING: TRYIING TO CHANGE THE PRICE OF THE GAMEPASS WILL RESULT IN PERMANENT BAN</strong></span>
                    </div>
                </div>
                <img src="/../api/images/success.png" alt="success icon" style="margin-top: 20px; margin-bottom: 26px; margin-left: 25%; width: 200px;">
            </div>

            <button class="purchase-button" onclick="buyMore()">Buy more</button>
        </div>
    </div>
    
<script src="/../../api/js/home.js"></script>
</body>
</html>