<?php
require __DIR__ . '/../db/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/../../api/css/style.css">
    <title>RBXMOON - History</title>
    <style>
    .main-content {
        margin-left: 0 !important;
        width: 100% !important;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding: 40px 20px;
    }

    .transactions-section {
        max-width: 900px;
        width: 100%;
    }

    .transaction-gp {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .copy-btn {
        background: rgba(88, 101, 242, 0.1);
        border: 1px solid rgba(88, 101, 242, 0.3);
        color: #5865f2;
        padding: 4px 8px;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.2s;
        font-size: 12px;
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .copy-btn:hover {
        background: rgba(88, 101, 242, 0.2);
        border-color: rgba(88, 101, 242, 0.5);
    }

    .copy-btn.copied {
        background: rgba(67, 181, 129, 0.1);
        border-color: rgba(67, 181, 129, 0.3);
        color: #43b581;
    }

    .copy-btn svg {
        width: 14px;
        height: 14px;
    }
    </style>
</head>
<head>
  <title>RBXMOON - History</title>
  <meta property="og:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta property="og:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
  <meta property="og:url" content="https://infernal.top" />
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary" />
  <meta name="twitter:title" content="RBXMOON - Your #1 Robux Vendor" />
  <meta name="twitter:description" content="On our website, you can buy Robux at the best prices with safest delivery. A proven and secure way to purchase Robux." />
</head>
<body>
    <div class="header">
        <div class="logo-section">
            <img src="/../api/images/logo.webp" alt="RBXMOON Logo" class="logo">
            <span class="company-name">RBXMOON</span>
            <div class="nav-links">
                <a href="/pages/tos.html" class="nav-link">TOS</a>
                <a href="https://discord.com/invites/" class="nav-link">Sell Robux</a>
                <a href="https://discord.com/invites/" class="nav-link">Discord</a>
            </div>
        </div>
        <div class="auth-section">
            <?php


            if (!isset($_SESSION['user'])) {
                header('Location: /../../pages/home.php');
                exit();
            }

            if (!isset($_SESSION['user'])) {
                echo '<a href="'.DISCORD_OAUTH_URL.'" class="login-btn" id="headerBtn">
                    <svg class="discord-icon" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152..."></path>
                    </svg>
                    Login/Register
                </a>';
            } else {
                $stmt = $pdo->prepare("SELECT balance FROM users WHERE discord_id = ?");
                $stmt->execute([$_SESSION['user']['discord_id']]);
                $balance = $stmt->fetchColumn();
                $balanceFormatted = number_format($balance, 2);

                echo '
    <div class="user-dropdown">
        <button class="user-dropdown-btn" title="View account menu">
            <img src="' . ($_SESSION['user']['thumbnail'] ?? '/../api/images/discord.png') . '" alt="avatar" class="user-avatar">
            <div class="user-details">
                <span class="user-username">'.$_SESSION['user']['username'].'</span>
                <span class="user-balance">$'.$balanceFormatted.'</span>
            </div>
            <svg class="dropdown-arrow" width="12" height="12" viewBox="0 0 12 12" fill="currentColor">
                <path d="M2 4L6 8L10 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none"/>
            </svg>
        </button>
        
        <div class="user-dropdown-menu">
            <a href="/pages/home.php" class="dropdown-item" title="Go to home page">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
                Home
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/pages/topup.php" class="dropdown-item" title="Add money to your account balance">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="12" y1="8" x2="12" y2="16"/>
                    <line x1="8" y1="12" x2="16" y2="12"/>
                </svg>
                Top Up
            </a>
            
            <div class="dropdown-divider"></div>
            
            <a href="/../api/helper2/api_logout.php" class="dropdown-item logout" title="Sign out of your account">
    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
        <polyline points="16 17 21 12 16 7"/>
        <line x1="21" y1="12" x2="9" y2="12"/>
    </svg>
    Logout
</a>

        </div>
    </div>';
            }
            ?>
        </div>
    </div>

    <div class="dashboard-container">
        <div class="main-content">
            <div class="transactions-section">
                <h3 class="section-title">Transaction History</h3>
                
                <div class="transactions-table">
                    <div class="transactions-header">
                        <span>Type</span>
                        <span>Gamepass/Address</span>
                        <span>Method</span>
                        <span>Amount</span>
                        <span>Status</span>
                    </div>
                    
                    <div id="transactionsList">
                        <?php
                        $discord_id = $_SESSION['user']['discord_id'];
                            
                            $stmt = $pdo->prepare("
                                SELECT 
                                    'Deposit' as type,
                                    address as gamepass,
                                    'Crypto' as method,
                                    amount,
                                    depo_status as status,
                                    created_at
                                FROM deposit 
                                WHERE depo_owner = ?
                                
                                UNION ALL
                                
                                SELECT 
                                    'Robux' as type,
                                    CAST(gamepass_id AS CHAR) as gamepass,
                                    'Balance' as method,
                                    paid_amt as amount,
                                    order_status as status,
                                    created_at
                                FROM orders 
                                WHERE puser = ?
                                
                                ORDER BY created_at DESC
                            ");
                            
                            $stmt->execute([$discord_id, $discord_id]);
                            $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
                            
                            if (count($transactions) == 0) {
                                echo '<div class="transaction-row"><div style="text-align: center; width: 100%; padding: 20px;">No transactions found</div></div>';
                            } else {
                                foreach ($transactions as $tx) {
                                    $statusClass = '';
                                    $statusIcon = '';
                                    
                                    switch ($tx['status']) {
                                        case 'completed':
                                            $statusClass = 'completed';
                                            $statusIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <polyline points="20,6 9,17 4,12"></polyline>
                                            </svg>';
                                            break;
                                        case 'pending':
                                            $statusClass = 'pending';
                                            $statusIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <polyline points="12,6 12,12 16,14"></polyline>
                                            </svg>';
                                            break;
                                        case 'canceled':
                                            $statusClass = 'failed';
                                            $statusIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <circle cx="12" cy="12" r="10"></circle>
                                                <line x1="15" y1="9" x2="9" y2="15"></line>
                                                <line x1="9" y1="9" x2="15" y2="15"></line>
                                            </svg>';
                                            break;
                                    }
                                    
                                    $fullGamepass = $tx['gamepass'];
                                    $gamepassDisplay = $tx['gamepass'];
                                    if ($tx['type'] == 'Deposit' && strlen($gamepassDisplay) > 25) {
                                        $gamepassDisplay = substr($gamepassDisplay, 0, 15) . '...' . substr($gamepassDisplay, -10);
                                    } elseif ($tx['type'] == 'Robux') {
                                        $fullGamepass = 'https://roblox.com/game-pass/' . $gamepassDisplay;
                                        $gamepassDisplay = $fullGamepass;
                                        if (strlen($gamepassDisplay) > 35) {
                                            $gamepassDisplay = substr($gamepassDisplay, 0, 32) . '...';
                                        }
                                    }
                                    
$amountDisplay = rtrim(rtrim(number_format((float)$tx['amount'], 7, '.', ''), '0'), '.');

                                    
                                    echo '
                                    <div class="transaction-row">
                                        <div class="transaction-id">' . htmlspecialchars($tx['type']) . '</div>
                                        <div class="transaction-gp">
                                            <button class="copy-btn" onclick="copyToClipboard(\'' . htmlspecialchars($fullGamepass, ENT_QUOTES) . '\', this)" title="Copy full address">
                                                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
                                                    <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                                                </svg>
                                            </button>
                                            <span>' . htmlspecialchars($gamepassDisplay) . '</span>
                                        </div>
                                        <div class="transaction-method">' . htmlspecialchars($tx['method']) . '</div>
                                        <div class="transaction-amount">' . $amountDisplay . '</div>
                                        <div class="transaction-status ' . $statusClass . '">
                                            <span>' . ucfirst($tx['status']) . '</span>
                                            ' . $statusIcon . '
                                        </div>
                                    </div>';
                                }
                            }
                        
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script src="/../../api/js/trans.js"></script>
<script>
function copyToClipboard(text, button) {
    navigator.clipboard.writeText(text).then(() => {
        const originalHTML = button.innerHTML;
        button.classList.add('copied');
        button.innerHTML = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"></polyline></svg>';
        
        setTimeout(() => {
            button.classList.remove('copied');
            button.innerHTML = originalHTML;
        }, 2000);
    }).catch(err => {
        console.error('Failed to copy:', err);
    });
}
</script>

</body>
</html>