document.addEventListener("DOMContentLoaded", () => {
    const dropdown = document.querySelector(".user-dropdown");
    const dropdownBtn = document.querySelector(".user-dropdown-btn");

    if (dropdown && dropdownBtn) {
        // Toggle dropdown visibility
        dropdownBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("active");
        });

        // Close dropdown when clicking outside
        document.addEventListener("click", (e) => {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove("active");
            }
        });
    }
});


// Copy wallet address button
document.getElementById('copyAddressBtn').addEventListener('click', function() {
    const walletAddress = document.getElementById('walletAddress').textContent;
    
    // Create a temporary textarea to copy the full address
    const tempInput = document.createElement('textarea');
    tempInput.value = walletAddress;
    tempInput.style.position = 'absolute';
    tempInput.style.left = '-9999px';
    document.body.appendChild(tempInput);
    
    tempInput.select();
    tempInput.setSelectionRange(0, 99999); // For mobile devices
    
    try {
        document.execCommand('copy');
        
        // Visual feedback
        const originalText = this.textContent;
        this.textContent = 'Copied!';
        this.style.background = '#10b981';
        
        setTimeout(() => {
            this.textContent = originalText;
            this.style.background = '';
        }, 2000);
    } catch (err) {
        console.error('Failed to copy:', err);
    }
    
    document.body.removeChild(tempInput);
});

// Copy crypto amount button
document.getElementById('copyAmountBtn').addEventListener('click', function() {
    const cryptoAmount = document.getElementById('cryptoAmount').textContent;
    
    const tempInput = document.createElement('textarea');
    tempInput.value = cryptoAmount;
    tempInput.style.position = 'absolute';
    tempInput.style.left = '-9999px';
    document.body.appendChild(tempInput);
    
    tempInput.select();
    tempInput.setSelectionRange(0, 99999);
    
    try {
        document.execCommand('copy');
        
        const originalText = this.textContent;
        this.textContent = 'Copied!';
        this.style.background = '#10b981';
        
        setTimeout(() => {
            this.textContent = originalText;
            this.style.background = '';
        }, 2000);
    } catch (err) {
        console.error('Failed to copy:', err);
    }
    
    document.body.removeChild(tempInput);
});