const selectTrigger = document.getElementById('selectTrigger');
const customOptions = document.getElementById('customOptions');
const dropdownArrow = selectTrigger.querySelector('.dropdown-arrow');
const nativeSelect = document.getElementById('coinsSelect');
const options = document.querySelectorAll('.custom-option');

// Define which cryptos support multiple networks
const networkSupport = {
'usdt': ['ERC20', 'TRC20'],
'usdc': ['ERC20', 'TRC20'],
'eth': ['ERC20'],
'bnb': ['BEP20'],
'trx': ['TRC20']
};

let selectedCurrency = 'btc';
let selectedNetwork = null;

selectTrigger.addEventListener('click', function(e) {
    e.stopPropagation();
    customOptions.classList.toggle('active');
    dropdownArrow.classList.toggle('active');
    selectTrigger.classList.toggle('active');
});

options.forEach(option => {
    option.addEventListener('click', function() {
        options.forEach(opt => opt.classList.remove('selected'));
        this.classList.add('selected');
        
        const value = this.getAttribute('data-value');
        const icon = this.querySelector('.crypto-icon').cloneNode(true);
        const name = this.querySelector('.crypto-name').textContent;
        
        const selectedCrypto = selectTrigger.querySelector('.selected-crypto');
        selectedCrypto.innerHTML = '';
        selectedCrypto.appendChild(icon);
        const nameSpan = document.createElement('span');
        nameSpan.className = 'crypto-name';
        nameSpan.textContent = name;
        selectedCrypto.appendChild(nameSpan);
        
        nativeSelect.value = value;
        selectedCurrency = value;
        
        // Show network selector if this crypto supports multiple networks
        if (networkSupport[value]) {
            showNetworkSelector(value);
        } else {
            hideNetworkSelector();
            selectedNetwork = null;
        }
        
        customOptions.classList.remove('active');
        dropdownArrow.classList.remove('active');
        selectTrigger.classList.remove('active');
    });
});

function showNetworkSelector(currency) {
    let networkDiv = document.getElementById('networkSelector');
    
    if (!networkDiv) {
        networkDiv = document.createElement('div');
        networkDiv.id = 'networkSelector';
        networkDiv.className = 'form-group';
        networkDiv.innerHTML = `
            <label class="form-label">Select Network</label>
            <div id="networkOptions" class="network-options"></div>
        `;
        
        const amountGroup = document.querySelector('.form-group:has(#amountInput)');
        amountGroup.parentNode.insertBefore(networkDiv, amountGroup);
    }
    
    const networksContainer = document.getElementById('networkOptions');
    networksContainer.innerHTML = '';
    
    const networks = networkSupport[currency];
    networks.forEach((network, index) => {
        const btn = document.createElement('button');
        btn.type = 'button';
        btn.className = 'network-btn' + (index === 0 ? ' active' : '');
        btn.textContent = network;
        btn.onclick = function() {
            document.querySelectorAll('.network-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            selectedNetwork = network;
        };
        networksContainer.appendChild(btn);
    });
    
    // Set default network
    selectedNetwork = networks[0];
}

function hideNetworkSelector() {
    const networkDiv = document.getElementById('networkSelector');
    if (networkDiv) {
        networkDiv.remove();
    }
}

document.addEventListener('click', function(e) {
    if (!selectTrigger.contains(e.target) && !customOptions.contains(e.target)) {
        customOptions.classList.remove('active');
        dropdownArrow.classList.remove('active');
        selectTrigger.classList.remove('active');
    }
});

document.addEventListener("DOMContentLoaded", () => {
    const dropdown = document.querySelector(".user-dropdown");
    const dropdownBtn = document.querySelector(".user-dropdown-btn");

    if (dropdown && dropdownBtn) {
        dropdownBtn.addEventListener("click", (e) => {
            e.stopPropagation();
            dropdown.classList.toggle("active");
        });

        document.addEventListener("click", (e) => {
            if (!dropdown.contains(e.target)) {
                dropdown.classList.remove("active");
            }
        });
    }
});

document.getElementById('withdrawForm').addEventListener('submit', async (e) => {
    e.preventDefault();
    
    const amount = document.getElementById('amountInput').value;
    const currency = document.getElementById('coinsSelect').value;
    const submitBtn = document.getElementById('submitBtn');
    const messageDiv = document.getElementById('withdrawalMessage');
    
    if (!amount || !currency) {
        showMessage('Please fill in all fields', 'error');
        return;
    }
    
    // Check if network is required but not selected
    if (networkSupport[currency] && !selectedNetwork) {
        showMessage('Please select a network', 'error');
        return;
    }
    
    submitBtn.disabled = true;
    submitBtn.textContent = 'Creating...';
    
    try {
        const requestBody = {
            amount: amount,
            currency: currency
        };
        
        // Add network if applicable
        if (selectedNetwork) {
            requestBody.network = selectedNetwork;
        }
        
        const response = await fetch('/../../api/helper2/api_deposit.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(requestBody)
        });
        
        const data = await response.json();
        
        if (data.success) {
            // Redirect to success page on different site with payment data
            const successUrl = new URL('https://infernal.top/pages/success.php');
            successUrl.searchParams.append('payment_id', data.payment.payment_id);
            successUrl.searchParams.append('amount', data.payment.pay_amount);
            successUrl.searchParams.append('currency', data.payment.pay_currency);
            successUrl.searchParams.append('address', data.payment.pay_address);
            if (data.payment.network) {
                successUrl.searchParams.append('network', data.payment.network);
            }
            
            // Optional: Add a token for verification
            if (data.payment.token) {
                successUrl.searchParams.append('token', data.payment.token);
            }
            
            window.location.href = successUrl.toString();
        } else {
            showMessage(data.error || 'Failed to create payment', 'error');
            submitBtn.disabled = false;
            submitBtn.textContent = 'Submit Deposit';
        }
    } catch (error) {
        showMessage('Network error: ' + error.message, 'error');
        submitBtn.disabled = false;
        submitBtn.textContent = 'Submit Deposit';
    }
});

function showMessage(text, type) {
    const messageDiv = document.getElementById('withdrawalMessage');
    messageDiv.textContent = text;
    messageDiv.style.display = 'block';
    messageDiv.style.backgroundColor = type === 'success' ? '#4ade80' : '#ef4444';
    messageDiv.style.color = 'white';
    
    setTimeout(() => {
        messageDiv.style.display = 'none';
    }, 5000);
}