<?php
header('Content-Type: application/json');

// Require config (optional if you need rates or database)
require __DIR__ . '/../../db/config.php';

// Read JSON input
$data = json_decode(file_get_contents('php://input'), true);

if (!$data || !isset($data['gamepass_id']) || !is_numeric($data['gamepass_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid gamepass ID'
    ]);
    exit;
}

$gamepassId = $data['gamepass_id'];

// Call Roblox API
$gamepassUrl = "https://apis.roblox.com/game-passes/v1/game-passes/{$gamepassId}/product-info";
$ch = curl_init($gamepassUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Handle response
if ($httpCode !== 200) {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to fetch gamepass data from Roblox'
    ]);
    exit;
}

$data = json_decode($response, true);

if (!$data || !isset($data['PriceInRobux'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid gamepass data'
    ]);
    exit;
}

// Return gamepass info
echo json_encode([
    'success' => true,
    'data' => [
        'PriceInRobux' => $data['PriceInRobux'],
        'IsForSale' => $data['IsForSale'],
        'Name' => $data['Name'] ?? 'Unknown',
        'Description' => $data['Description'] ?? '',
    ]
]);
