<?php
require __DIR__ . '/../../db/config.php';

if (!isset($_GET['code'])) {
    header('Location: /../../pages/home.php');
    exit;
}


$code = $_GET['code'];

// Get access token
$token = json_decode(file_get_contents('https://discord.com/api/oauth2/token', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => 'Content-Type: application/x-www-form-urlencoded',
        'content' => http_build_query([
            'client_id' => DISCORD_CLIENT_ID,
            'client_secret' => DISCORD_CLIENT_SECRET,
            'grant_type' => 'authorization_code',
            'code' => $code,
            'redirect_uri' => DISCORD_REDIRECT_URI,
        ]),
    ],
])), true);

if (!isset($token['access_token'])) {
    die('Error fetching Discord token.');
}

// Get user info
$opts = [
    "http" => ["header" => "Authorization: Bearer {$token['access_token']}"]
];
$user = json_decode(file_get_contents('https://discord.com/api/users/@me', false, stream_context_create($opts)), true);

// Check if user exists
$stmt = $pdo->prepare("SELECT * FROM users WHERE discord_id = ?");
$stmt->execute([$user['id']]);
$dbUser = $stmt->fetch();

if (!$dbUser) {
    // Insert new user
    $stmt = $pdo->prepare("INSERT INTO users (discord_id, username, thumbnail, ip) VALUES (?, ?, ?, ?)");
    $stmt->execute([
        $user['id'],
        $user['username'] . '#' . $user['discriminator'],
        "https://cdn.discordapp.com/avatars/{$user['id']}/{$user['avatar']}.png",
        $_SERVER['REMOTE_ADDR']
    ]);
} else {
    // Update last login
    $stmt = $pdo->prepare("UPDATE users SET last_login = NOW() WHERE discord_id = ?");
    $stmt->execute([$user['id']]);
}

// Set session
$_SESSION['user'] = [
    'discord_id' => $user['id'],
    'username' => $user['username'] . '#' . $user['discriminator'],
    'thumbnail' => "https://cdn.discordapp.com/avatars/{$user['id']}/{$user['avatar']}.png",
];

// Redirect back
    header('Location: /../../pages/home.php');

